﻿Start-Transcript -Path "$env:TEMP\redbox-touch-install.log" -Append

#region Functions

Function Start-Installation
{
    param
    (
        [Parameter(Position=0,Mandatory=$true)]
        [System.String]$Exe,
        [Parameter(Position=1)]
        [System.String]$Args=""
    )    
    $CmdLineArgs=@("/C","`"$Exe`"",$Args)
    Start-Process -FilePath "$env:windir\System32\cmd.exe" -ArgumentList $CmdLineArgs -Wait
}

#endregion

#region Initialization
$CurrentDirectory=[System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Definition)
$IsRunningInTS=$false
$tsenv=$null
$tsprog=$null
$IsPresent=$false

#See If We Are Running During a Task Sequence
try
{
    $tsenv = New-Object -COMObject Microsoft.SMS.TSEnvironment
    $tsprog= New-Object -ComObject Microsoft.SMS.TsProgressUI
    $IsRunningInTS=$true
}
catch
{
    $IsRunningInTS=$false
}


#endregion

#region Touchscreen Software Installations
$MT7HWID="USB\\VID_0596&PID_0001"
$EloHWID="USB\\VID_04E7"
$GenTouchHWID="USB\\VID_0DFC"

$MT7Setup="MT7.13.14.Win32-64\setup.exe"
$EloSetup="SW602172_EloMouseTouch_5.5.1\32Bit\elosetup.exe"
$GenTouchSetup="GTDrv4.2.2.1SU_XPVISTAWIN7_EN\setup.exe"

$MT7Args='-s -SMS'
$EloArgs="/s /iu"
$GenTouchArgs='-s -SMS'
#endregion

#region Detection and Installation

#If We Are Running In A Task Sequence Close The Progress Dialog
if($IsRunningInTS)
{
    $tsprog.CloseProgressDialog()
}

#We try to find the 3M (MT7) device first
$wql="SELECT * FROM Win32_PnpEntity WHERE PNPDeviceID LIKE '$MT7HWID%'"
$PnpDevices=Get-WmiObject -Query $wql
foreach ($PnpDevice in $PnpDevices)
{
    if($PnpDevice -ne $null)
    {
        $IsPresent=$true
        Write-Host "Found 3M Touchscreen $($PnpDevice.Description) ID:$($PnpDevice.PnpDeviceId)"
        $ExePath=Join-Path $CurrentDirectory $MT7Setup
        #Fire Off The Installation
        Start-Installation -Exe $ExePath -Args $MT7Args
        break
    }
}

#So...No 3M is present...
if(-not $IsPresent)
{
    #Next we look for the Elo device...
    $wql="SELECT * FROM Win32_PnpEntity WHERE PNPDeviceID LIKE '$EloHWID%'"
    $PnpDevices=Get-WmiObject -Query $wql
    foreach ($PnpDevice in $PnpDevices)
    {
        if($PnpDevice -ne $null)
        {
            $IsPresent=$true
            Write-Host "Found Elo Touchscreen $($PnpDevice.Description) ID:$($PnpDevice.PnpDeviceId)"
            $ExePath=Join-Path $CurrentDirectory $EloSetup
            #Fire Off The Installation
            Start-Installation -Exe $ExePath -Args $EloArgs
            break            
        }
    }
}

#Finally we'll look for the General Touch one...
if(-not $IsPresent)
{
    #Next we look for the General Touch device...
    $wql="SELECT * FROM Win32_PnpEntity WHERE PNPDeviceID LIKE '$GenTouchHWID%'"
    $PnpDevices=Get-WmiObject -Query $wql
    foreach ($PnpDevice in $PnpDevices)
    {
        if($PnpDevice -ne $null)
        {
            $IsPresent=$true
            Write-Host "Found General Touch Touchscreen $($PnpDevice.Description) ID:$($PnpDevice.PnpDeviceId)"
            $ExePath=Join-Path $CurrentDirectory $GenTouchSetup
            #Fire Off The Installation
            Start-Installation -Exe $ExePath -Args $GenTouchArgs
            break            
        }
    }
}

if(-not $IsPresent)
{
    Write-Host "No Touchscreen detected!`n"
}

#If We Are Running In A Task Sequence
if($IsRunningInTS)
{
    $step=[System.Convert]::ToInt64($tsenv.Value("_SMSTSNextInstructionPointer"))
    $maxStep=[System.Convert]::ToInt64($tsenv.Value("_SMSTSInstructionTableSize"))
    $tsprog.ShowTSProgress($tsenv.Value("_SMSTSOrgName"),$tsenv.Value("_SMSTSPackageName"),$tsenv.Value("_SMSTSCustomProgressDialogMessage"),$tsenv.Value("_SMSTSCurrentActionName"),$step,$maxStep)
}

#endregion

Write-Host "Complete"

Stop-Transcript|Out-Null